VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{6FBA474E-43AC-11CE-9A0E-00AA0062BB4C}#1.0#0"; "SYSINFO.OCX"
Begin VB.Form Hauptfenster 
   Caption         =   "LCD-Ausgabe"
   ClientHeight    =   2655
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4380
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2655
   ScaleWidth      =   4380
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Timer myTimer 
      Enabled         =   0   'False
      Interval        =   60000
      Left            =   720
      Top             =   2040
   End
   Begin SysInfoLib.SysInfo mySysinfo 
      Left            =   1440
      Top             =   1920
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock mySocket 
      Left            =   240
      Top             =   2040
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.CommandButton btnStartStop 
      Caption         =   "Start"
      Height          =   375
      Left            =   3240
      TabIndex        =   1
      Top             =   2040
      Width           =   855
   End
   Begin VB.Label txtInfo 
      BorderStyle     =   1  'Fest Einfach
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   15
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1575
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   3855
   End
End
Attribute VB_Name = "Hauptfenster"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type MEMORYSTATUS
  dwLength As Long
  dwMemoryLoad As Long
  dwTotalPhys As Long
  dwAvailPhys As Long
  dwTotalPageFile As Long
  dwAvailPageFile As Long
  dwTotalVirtual As Long
  dwAvailVirtual As Long
End Type

Private memInfo As MEMORYSTATUS

Private Declare Sub GlobalMemoryStatus Lib "kernel32" (lpBuffer As MEMORYSTATUS)

' IO-Warrior handle
Dim iowHandle As Long
' Data buffer for writing to LCD
Dim data(7) As Byte

Public Function UsedMemory() As Double
    Dim result As Double
    
    GlobalMemoryStatus memInfo
    result = memInfo.dwTotalPhys - memInfo.dwAvailPhys
    UsedMemory = Format((result / 1024) / 1024, "###,###,##0.0")
End Function

Private Function FreeMemory() As Double
    Dim result As Double
    
    GlobalMemoryStatus memInfo
    result = memInfo.dwAvailPhys
    FreeMemory = Format((result / 1024) / 1024, "###,###,##0.0")
End Function

Private Sub btnStartStop_Click()
    If btnStartStop.Caption = "Start" Then
        btnStartStop.Caption = "Stop"
        myTimer.Enabled = True
        Call InitLCD
        myTimer_Timer
    Else
        btnStartStop.Caption = "Start"
        myTimer.Enabled = False
        txtInfo.Caption = ""
    End If
End Sub

Private Sub myTimer_Timer()
    Dim vers As String
    Dim Res As Long
    
    Select Case mySysinfo.OSPlatform
    Case 0
       vers = "Unbekanntes System"
    Case 1
       vers = "Windows 9x/ME, Version " & mySysinfo.OSVersion & ", Build " & mySysinfo.OSBuild
    Case 2
       If Left(mySysinfo.OSVersion, 1) = "5" Then
          vers = "Win XP, Build " & mySysinfo.OSBuild
       Else
          vers = "Win NT, Build " & mySysinfo.OSBuild
       End If
    End Select
    
    txtInfo.Caption = vers & Chr(10)
    txtInfo.Caption = txtInfo.Caption & "IP is " & mySocket.LocalIP & Chr(10)
    txtInfo.Caption = txtInfo.Caption & "Memory used: " & UsedMemory() & "M" & Chr(10)
    txtInfo.Caption = txtInfo.Caption & "Memory free: " & FreeMemory() & "M"
    
    Call DisplayLineOnLCD(1, vers)
    Call DisplayLineOnLCD(2, "IP is " & mySocket.LocalIP)
    Call DisplayLineOnLCD(3, "Memory used: " & UsedMemory() & "M")
    Call DisplayLineOnLCD(4, "Memory free: " & FreeMemory() & "M")
End Sub

Private Sub DisplayLineOnLCD(line As Integer, info As String)
    Dim Res As Long
    Dim Address As Byte
    
    If line = 1 Then
            Address = &H0
    End If
    If line = 2 Then
            Address = &H40
    End If
    If line = 3 Then
            Address = &H14
    End If
    If line = 4 Then
            Address = &H54
    End If

    Res = IowKitSetDDRAMAddr(iowHandle, 1, Address)
    Res = IowKitWriteStringLCD(iowHandle, 1, info)
End Sub

Private Sub InitLCD()
    Dim Res As Long
    
    ' Initialize everything
    ' Open device
    iowHandle = IowKitOpenDevice()
    ' Fail if can't open
    If (iowHandle = 0) Then
        ' Exit from program
        MsgBox "Can not open device!", 0, "Error"
        End
    End If
    ' Enable IIC
    Res = IowKitEnableLCD(iowHandle, 1, 1)
    ' Check for error
    If (Res <> 8) Then
        ' Something is wrong, exit
        MsgBox "LCD not present", 0, "Error"
        End
    End If
    ' Initialize LCD screen
    Res = IowKitInitLCD(iowHandle, 1, 1)
    ' Turn on display
    Res = IowKitDispControlLCD(iowHandle, 1, True, False, False)
    ' Set cursor movement to right and no shifting
    Res = IowKitEntryModeSet(iowHandle, 1, True, False)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim Res As Long
    ' Disable LCD
    Res = IowKitEnableLCD(iowHandle, 1, 0)
    ' Close IO-Warrior device
    IowKitCloseDevice (iowHandle)
End Sub

Private Sub form_load()
    Call btnStartStop_Click
End Sub
